/* sys/param.h (gcc/libextensions: BSD compatibility header) */

#ifndef _SYS_PARAM_H
#define _SYS_PARAM_H

#if defined (__cplusplus)
extern "C" {
#endif

/*- Parts:
 * Copyright (c) 1982, 1986, 1989, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)param.h	8.2 (Berkeley) 1/21/94
 */
/* 
 * We want to remain source compatible with emx legacy and to provide 
 * most of that hackish stuff that BSD expects to be here. Pls report
 * all outstanding bugs! We kow: The macros here severely pollute the 
 * namespace and violate the important ANSI rule to underscore all 
 * symbols in system libaries!
 */

#ifndef _POSIX_OS2_ROOT    /* ((__const__ char*)_getenv(POSIXOS2ROOT)) 	"/" */
#define _POSIX_OS2_ROOT _getPosixOS2Root();
extern __const__ char*_getPosixOS2Root(void);
#endif 

#define MAXHOSTNAMELEN	120	/* max length of hostname; cf. OS/2 toolkit */
#define	NZERO		 0	/* No! default BSD "nice" feature!! */
#define	MAXLOGNAME	 0	/* No! max login name length. */

#define	BSD	199306		/* System version (year & month). */
#define BSD4_3	1
#define BSD4_4	1		/* We fake a generic 4.4 BSD. */

#define _POSIXOS2_VERSION	200003	/* System version (year & month). */

/* Machine type dependent parameters. */
#define	_MACHINE	i386
#define	MACHINE		"i386"
#define	_MACHINE_ARCH	i386
#define	MACHINE_ARCH	"i386"
#define	MID_MACHINE	MID_I386

#include <sys/types.h>		/* BSD expects sys/types.h in sys/param.h */
	/* #include <sys/simplelock.h> ?? Need that??*/

/* Signals. BSD even expects this one to be here?! */
#include <sys/signal.h>

/*
 * Round p (pointer or byte index) up to a correctly-aligned value
 * for all data types (int, long, ...).   The result is u_int and
 * must be cast to any desired pointer type.
 */
#define ALIGNBYTES	(sizeof(int) - 1)
#define ALIGN(p)	(((u_int)(p) + ALIGNBYTES) &~ ALIGNBYTES)

#define	PGSHIFT		12		/* LOG2(NBPG) */
#define	NBPG		(1 << PGSHIFT)	/* bytes/page */
#define	PGOFSET		(NBPG-1)	/* byte offset into page */
#define	NPTEPG		(NBPG/(sizeof (pt_entry_t)))

#define	DEV_BSHIFT	9		/* log2(DEV_BSIZE) */
#define	DEV_BSIZE	(1 << DEV_BSHIFT)
#define	BLKDEV_IOSIZE	2048
#define	MAXPHYS		(64 * 1024)	/* max raw I/O transfer size */

#define	CLSIZELOG2	0
#define	CLSIZE		(1 << CLSIZELOG2)

/* NOTE: SSIZE, SINCR and UPAGES must be multiples of CLSIZE */
#define	SSIZE		1		/* initial stack size/NBPG */
#define	SINCR		1		/* increment of stack/NBPG */
#define	UPAGES		2		/* pages of u-area */
#define	USPACE		(UPAGES * NBPG)	/* total size of u-area */


/* pages ("clicks") to disk blocks */
#define	ctod(x)		((x) << (PGSHIFT - DEV_BSHIFT))
#define	dtoc(x)		((x) >> (PGSHIFT - DEV_BSHIFT))

/* bytes to pages */
#define	ctob(x)		((x) << PGSHIFT)
#define	btoc(x)		(((x) + PGOFSET) >> PGSHIFT)

/* bytes to disk blocks */
#define	dbtob(x)	((x) << DEV_BSHIFT)
#define	btodb(x)	((x) >> DEV_BSHIFT)

/*
 * Mach derived conversion macros
 */
#define	i386_round_pdr(x)	((((unsigned)(x)) + PDOFSET) & ~PDOFSET)
#define	i386_trunc_pdr(x)	((unsigned)(x) & ~PDOFSET)
#define	i386_btod(x)		((unsigned)(x) >> PDSHIFT)
#define	i386_dtob(x)		((unsigned)(x) << PDSHIFT)
#define	i386_round_page(x)	((((unsigned)(x)) + PGOFSET) & ~PGOFSET)
#define	i386_trunc_page(x)	((unsigned)(x) & ~PGOFSET)
#define	i386_btop(x)		((unsigned)(x) >> PGSHIFT)
#define	i386_ptob(x)		((unsigned)(x) << PGSHIFT)

#include <limits.h>

#define	SIZE_T_MAX	UINT_MAX	/* max value for a size_t */

#define	UID_MAX		INT_MAX		/* max value for a uid_t */
#define	GID_MAX		INT_MAX		/* max value for a gid_t */

#define	UQUAD_MAX	ULONG_LONG_MAX    		/* max unsigned quad */
#define	QUAD_MAX	LONG_LONG_MAX     		/* max signed quad */
#define	QUAD_MIN	LONG_LONG_MIN   		/* min signed quad */

#define LONG_BIT	32

#if !defined (PAGE_SIZE)
#define PAGE_SIZE 0x1000
#endif

#if !defined (HZ)
#define HZ        100
#endif
#if !defined (EOF)
#define EOF (-1)
#endif

#define	NBPW	sizeof(int)	/* number of bytes per word (integer) */

#define	CMASK	022		/* default file mask: S_IWGRP|S_IWOTH */
#define	NODEV	(dev_t)(-1)	/* non-existent device */

/*
 * File system parameters and macros.
 *
 * The file system is made out of blocks of at most MAXBSIZE units, with
 * smaller units (fragments) only in the last direct block.  MAXBSIZE
 * primarily determines the size of buffers in the buffer pool.  It may be
 * made larger without any effect on existing file systems; however making
 * it smaller makes some file systems unmountable.
 */

/*
 * MAXPATHLEN defines the longest permissable path length after expanding
 * symbolic links. It is used to allocate a temporary buffer from the buffer
 * pool in which to do the name expansion, hence should be a power of two,
 * and must be less than or equal to MAXBSIZE.  MAXSYMLINKS defines the
 * maximum number of symbolic links that may be expanded in a path name.
 * It should be set high enough to allow all legitimate uses, but halt
 * infinite loops reasonably quickly.
 */
#define	MAXSYMLINKS	3		/* fake with copy for now */

 /* max bytes of fully qualified path name: a file system property */

#ifndef PATH_MAX  /* OS/2 does not use a constant but a FS query */
#define PATH_MAX 260 
extern __const__ int _mxPath(void); /* return max path length or -1 (error) */
#endif /* ! PATH_MAX */

/* all the following values are questionable: Fix me! */
#define	LINK_MAX   32767	/* fake max file link count: no hard links! */
#define	ARG_MAX	   (8 * 1024)	/* max bytes for an exec function (safe?) */
#define	NCARGS	   ARG_MAX
#define	CHILD_MAX  80		/* max simultaneous processes (safe?) */
#define	MAXUPRC    CHILD_MAX	/* max simultaneous processes */
#define	OPEN_MAX   64		/* max open files per process (safe?) */
#define	NOFILE     OPEN_MAX	/* max open files per process (soft) */
#define	NOFILE_MAX 1024		/* max open files per process (hard) */
#define PIPE_BUF   512		/* max bytes for atomic pipe writes (safe?) */
#define	MAXCOMLEN  16		/* max command name remembered */
#define	MAXINTERP  64		/* max interpreter file name length */
#define NAME_MAX   PATH_MAX	/* max bytes in a file name (safe?) */

#ifndef MAXPATHLEN 
#define MAXPATHLEN 	PATH_MAX
#endif
#if !defined (MAXNAMLEN)
#define MAXNAMLEN  MAXPATHLEN 
#endif
#if !defined (FILENAME_MAX)
#define	FILENAME_MAX    PATH_MAX	/* must be <= PATH_MAX */
#endif

/* System V/ANSI C; this is the wrong way to do this, do *not* use these. */
#if !defined (P_tmpdir)
# define	P_tmpdir	"/var/tmp/"
# define	L_tmpnam	PATH_MAX /* XXX must be == PATH_MAX */
#endif
#if !defined (TMP_MAX)
#define TMP_MAX         1000
#endif

  /* the following defaults are probably too small, but you can redefine them */
#if !defined (BUFSIZ)
#define BUFSIZ 5120
#endif
#if !defined (FOPEN_MAX)
#define	FOPEN_MAX	14	/* must be <= OPEN_MAX */
#endif 		/* FOPEN_MAX is a minimum maximum; should be the number of 
 * descriptors that the kernel can provide without allocation of a resource 
 * that can fail without the process sleeping.  Do not use this for anything. */

#ifndef RE_DUP_MAX
#define	RE_DUP_MAX	  255	/* max RE's in interval notation */
#endif

#define	COLL_WEIGHTS_MAX	    2	/* max weights for order keyword */
#define	EXPR_NEST_MAX		   32	/* max expressions nested in expr(1) */
#define	LINE_MAX		  510	/* max bytes in an input line (safe?) */
#define	IOV_MAX			 1024	/* max # of iov's (readv,sendmsg,etc) */

/*
 * Machine-independent constants (some used in following include files).
 * Redefined constants are from POSIX 1003.1 limits file.
 *
 * MAXCOMLEN should be >= sizeof(ac_comm) (see <acct.h>)
 * MAXLOGNAME should be >= UT_NAMESIZE (see <utmp.h>)
 */

	/* BSD names for some <limits.h> values.  */
#define	NBBY		      CHAR_BIT
#define	BC_BASE_MAX	      INT_MAX	/* max ibase/obase values in bc(1) */
#define	BC_DIM_MAX		65535	/* max array elements in bc(1) */
#define	BC_SCALE_MAX	      INT_MAX	/* max scale value in bc(1) */
#define	BC_STRING_MAX	      INT_MAX	/* max const string length in bc(1) */
#ifndef	NGROUPS
	/* no groups yet!: 0 value currently */
#define	NGROUPS	NGROUPS_MAX 	/* supplemental group IDs are available */
#endif
#ifndef NOGROUP
#define NOGROUP	(-1)		/* marker for empty group set member */
#endif

#define MAX_INPUT _POSIX_MAX_INPUT /* max size of the type-ahead buffer */
#define MAX_CANON _POSIX_MAX_CANON
#define	CANBSIZ	  MAX_CANON 	/* max bytes in term canonical input line */

#if !defined (NULL)
#if defined (__cplusplus)
#define NULL 0
#else
#define NULL ((void *)0)
#endif
#endif

/* Bit map related macros. */
#define	setbit(a,i)	((a)[(i)/NBBY] |= 1<<((i)%NBBY))
#define	clrbit(a,i)	((a)[(i)/NBBY] &= ~(1<<((i)%NBBY)))
#define	isset(a,i)	((a)[(i)/NBBY] & (1<<((i)%NBBY)))
#define	isclr(a,i)	(((a)[(i)/NBBY] & (1<<((i)%NBBY))) == 0)

/*
 * Scale factor for scaled integers used to count %cpu time and load avgs.
 *
 * The number of CPU `tick's that map to a unique `%age' can be expressed
 * by the formula (1 / (2 ^ (FSHIFT - 11))).  The maximum load average that
 * can be calculated (assuming 32 bits) can be closely approximated using
 * the formula (2 ^ (2 * (16 - FSHIFT))) for (FSHIFT < 15).
 *
 * For the scheduler to maintain a 1:1 mapping of CPU `tick' to `%age',
 * FSHIFT must be at least 11; this gives us a maximum load avg of ~1024.
 */
#define	FSHIFT	11		/* bits to right of fixed binary point */
#define FSCALE	(1<<FSHIFT)

/* Macros for counting and rounding. */
#ifndef howmany
#define	howmany(x, y)	(((x)+((y)-1))/(y))
#endif
#define	roundup(x, y)	((((x)+((y)-1))/(y))*(y))
#define powerof2(x)	((((x)-1)&(x))==0)

/* Macros for min/max. */
#ifndef _KERNEL
#define	MIN(a,b) (((a)<(b))?(a):(b))
#define	MAX(a,b) (((a)>(b))?(a):(b))
#endif

/* Don't try to do this inline for now */

#if !defined (htonl)
#define htonl(X) _swapl(X)
#define ntohl(X) _swapl(X)
#define htons(X) _swaps(X)
#define ntohs(X) _swaps(X)
#endif

unsigned short _swaps(unsigned short _x);
unsigned long _swapl(unsigned long _x);

#if defined (__cplusplus)
}
#endif
#endif /* not _SYS_PARAM_H */
