/* param.c - statical values:  - emx/gcc */

#define INCL_DOSFILEMGR
#define INCL_DOSMISC
#include <os2.h>

#include <unistd.h>
#include <sys/param.h>
#include <sys/unistdx.h>
#include <errno.h>
#include <sys/errnox.h>
#include <stdlib.h>
#include <paths.h>

	extern __const__ int
_mxPath(void) /* return maximal path length or -1 (error) */
{
 int buf;
 const APIRET 
  rc = DosQuerySysInfo(QSV_MAX_PATH_LENGTH, QSV_MAX_PATH_LENGTH, 
						&buf, sizeof(buf));
  if (rc) {errno = _rc2Errno(rc); return(-1);}

  return(buf);
}

static const char *__param_PosixOS2Root = "/";

	extern const char *
_getPosixOS2Root(void)
{
	if (!(__param_PosixOS2Root = getenv("POSIXOS2ROOT")) ) 
		fputs(
"param.c: _getPosixOS2Root(): Error: You must set the environment\n\
variable POSIXOS2ROOT to the root of your Unix-tree!\n", stderr);

	return (const char*)__param_PosixOS2Root;
}

