/* resource.c (libext + gcc) - bsd compatibility */
/* $Id: resource.c,v 1.1 2000/04/17 08:23:42 veit Exp $ */

/*- Parts:
 * Copyright (c) 1982, 1986, 1991, 1993
 *	The Regents of the University of California.  All rights reserved.
 * (c) UNIX System Laboratories, Inc.
 * All or some portions of this file are derived from material licensed
 * to the University of California by American Telephone and Telegraph
 * Co. or Unix System Laboratories, Inc. and are reproduced herein with
 * the permission of UNIX System Laboratories, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)kern_resource.c	8.5 (Berkeley) 1/21/94
 */

#define INCL_DOSPROCESS
#define INCL_DOSFILEMGR
#define INCL_DOSMISC
#include <os2.h>

#include <time.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/param.h>
#include <sys/resource.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <sys/errnox.h>

/* Restrictions: Returns only priority of current thread, both arguments
 * WHICH and WHO are just ignored. 
 */
	extern int
getpriority(int which, int who)
{
	if (!(which == PRIO_PROCESS || which == PRIO_PGRP || which == 
	  PRIO_USER) || who < 0 ) {
		errno = EINVAL;
		return(-1);
	} {
	 PTIB tib_p;
	 PPIB ppib_p;
	 APIRET rc;
	 int prio;

	rc = DosGetInfoBlocks(&tib_p, &ppib_p);
	if (rc) {errno = _rc2Errno(rc); return(-1);}

	prio = tib_p->tib_ptib2->tib2_ulpri - 16;
	return(prio);
	}
}

	extern int
setpriority(int which, int who, int prio)
{
	if (!(which == PRIO_PROCESS || which == PRIO_PGRP || which == 
	  PRIO_USER) || who < 0 || (prio < 20 && prio < 0) ||
	  (prio > 20 && prio > 0) ) {
		errno = EINVAL;
		return(-1);
	}
	if (prio < 0) {
		if (getgid() != 0) {
			errno = EACCES;
			return(-1);
		}
		if (prio < PRIO_MIN) 
			prio = PRIO_MIN;

		prio = (-prio + 15);
	}
	else if (prio > PRIO_MAX)
		prio = PRIO_MAX;
	{
	APIRET rc;
	if (which == PRIO_USER) { 	/* change all prio's */
		rc = DosSetPriority(PRTYS_PROCESS, 0, prio, (ULONG)who);
		if (rc) {errno = _rc2Errno(rc); return(-1);}

	} else {
		if (which == PRIO_PGRP || 
				which == PRIO_PROCESS) { 	/* change prio of grp WHO */
			rc = DosSetPriority(PRTYS_PROCESSTREE, 0, prio, (ULONG)who);
			if (rc) {errno = _rc2Errno(rc); return(-1);}
		}
	}}
	return(0);
}

	extern unsigned long  /* return MAXWAIT time for low priority threads */
_getMaxPrMem(void)
{
 ULONG maxprmem;
 const APIRET 
	rc = DosQuerySysInfo(QSV_MAXPRMEM, QSV_MAXPRMEM,&maxprmem,
					sizeof(maxprmem));
	if (rc) {
		errno = _rc2Errno(rc); 
		return((unsigned long)-1);
	}
	return (unsigned long)maxprmem;
}
	extern unsigned long  /* return MAXWAIT time for low priority threads */
_getMaxWait(void)
{
 ULONG maxwait;
 APIRET 
	rc = DosQuerySysInfo(QSV_DYN_PRI_VARIATION, QSV_DYN_PRI_VARIATION,&maxwait,
					sizeof(maxwait));
	if (rc) {
		errno = _rc2Errno(rc); 
		return((unsigned long)-1);
	}
	if (!maxwait)
		fputs("\
libext: resource.c: _getMaxWait(): Warning: Absolute priorities!\n\
Maximum CPU-time value is not reliable.",stderr);

	rc = DosQuerySysInfo(QSV_MAX_WAIT, QSV_MAX_WAIT,&maxwait,
					sizeof(maxwait));
	if (rc) {
		errno = _rc2Errno(rc); 
		return((unsigned long)-1);
	}
	return (unsigned long)maxwait;
}
	extern unsigned long  		/* return total available physical memory */
_getTotalPhysMem(void)
{
 ULONG totphymem;
 const APIRET 
	rc = DosQuerySysInfo(QSV_TOTPHYSMEM, QSV_TOTPHYSMEM,&totphymem,
					sizeof(totphymem));
	if (rc) {
		errno = _rc2Errno(rc); 
		return((unsigned long)-1);
	}
	return (unsigned long)totphymem;
}

	extern unsigned long  /* adjusts and returns process max file handles */
_relMaxFileHandles(long int adjust)
{
 ULONG CurMaxFH;
 const APIRET
	rc = DosSetRelMaxFH(&adjust, &CurMaxFH);
	if (rc) {
		errno = _rc2Errno(rc); 
		return((unsigned long)-1);
	}
	return(CurMaxFH);
}
	extern int 
getrlimit(int res, struct rlimit *rl)
{
	if (res < 0 || res >= RLIM_NLIMITS)
		{errno = EINVAL; return(-1);}
	if (rl == NULL)
		{errno = EFAULT; return(-1);}

	switch(res) {
	 case RLIMIT_CPU: 		/* maximum cpu time in seconds per process */
		rl->rlim_cur = _getMaxWait(); /* we use config.sys MAXWAIT as approx. */
		if (rl->rlim_cur == (unsigned long)-1) 
			return(-1); 
		rl->rlim_max = _MAX_LIMIT_CPU;
		return(0);
	 case RLIMIT_FSIZE: 		/* maximum file size for current process */
		rl->rlim_cur = _MAX_LIMIT_FSIZE; /* declaratory */
		rl->rlim_max = _MAX_LIMIT_FSIZE; /* declaratory */
		return(0);
	 case RLIMIT_DATA: 		/* maximum data size for current process */
		rl->rlim_cur = _getMaxPrMem();
		if (rl->rlim_cur == (unsigned long)-1)
			return(-1);
		rl->rlim_max = _getMaxPrMem();
		if (rl->rlim_cur == (unsigned long)-1)
			return(-1);
		return(0);
	 case RLIMIT_CORE:		/* maximum core file size for current process */
		rl->rlim_cur = _MAX_LIMIT_CORE; /* declaratory */
		rl->rlim_max = _MAX_LIMIT_CORE; /* declaratory */
		return(0);
	 case RLIMIT_STACK:		/* maximum stack size for current process */
		rl->rlim_cur = _MAX_LIMIT_STACK; /* declaratory */
		rl->rlim_max = _MAX_LIMIT_STACK; /* declaratory */
		return(0);
	 case RLIMIT_RSS:		/* maximum resident set size for current process */
		rl->rlim_cur = _getTotalPhysMem() / 2;
		if (rl->rlim_cur == (unsigned long)-1)
			return(-1);
		rl->rlim_max = _getTotalPhysMem() - 4*1024*1024; /* spare 4Mb for kernel */
		if (rl->rlim_cur == (unsigned long)-1)
			return(-1);
		return(0);
	 case RLIMIT_NPROC:		/* number of processes (current user) */
		rl->rlim_cur = NPROC; /* single user system, use global max */
		rl->rlim_max = 4095 - 5;
		return(0);
	 case RLIMIT_NOFILE:		/* number of open files (current process) */
		rl->rlim_cur = _relMaxFileHandles(0L);
		if (rl->rlim_cur == (unsigned long)-1)
			return(-1);
		rl->rlim_max = NOFILE_MAX;
		return(0);
	 case RLIMIT_MEMLOCK:	/* locked-in-memory address space */
		/* not yet implemented */
	 default:
		errno = ENOTSUP;
		return(-1);
	}
	return(0);
}
	extern unsigned long  /* adjusts process max file handles */
_setMaxFileHandles(unsigned long adjust)
{
 const APIRET
	rc = DosSetMaxFH(adjust);
	if (rc) {
		errno = _rc2Errno(rc); 
		return((unsigned long)-1);
	}
	return(adjust);
}
	extern int 
setrlimit(int res, __const__ struct rlimit *rlim)
{
	if (res < 0 || res > RLIM_NLIMITS) 
		{errno = EINVAL; return(-1);}
	if (rlim == NULL)
		{errno = EFAULT; return(-1);}
		
	switch(res) {
	 case RLIMIT_CPU: 		/* cpu time in milliseconds */

		break;
	 case RLIMIT_FSIZE: 		/* maximum file size */

		break;
	 case RLIMIT_DATA: 		/* data size */

		break;
	 case RLIMIT_CORE:		/* core file size */

		break;
	 case RLIMIT_STACK:		/* stack size */

		break;
	 case RLIMIT_RSS:		/* resident set size */

		break;
	 case RLIMIT_NPROC:		/* number of processes */

		break;
	 case RLIMIT_NOFILE: {		/* number of open files */
	  unsigned long adjust;
		(rlim->rlim_cur >= rlim->rlim_max) ? (adjust = rlim->rlim_cur)
				: (adjust = rlim->rlim_max);
		adjust = _setMaxFileHandles(adjust);
		if (adjust == (unsigned long)-1)
			return(-1);
		return(0);
	 }
	 case RLIMIT_MEMLOCK:	/* locked-in-memory address space */

		break;
	 default:				/* fall-through for unimplemented values */
		errno = ENOTSUP;
		return(-1);
	}
	errno = EPERM;
	return(-1);
}
	extern int  
getrusage(int who, struct rusage *usage)
{		/* falsify some statistics for to keep W. Churchill happy ;-) */
 struct clockinfo *cl_p;

	if ( !(cl_p = _getClockInfo()) )
		return(-1);
	if (usage == NULL)
		{errno = EFAULT; return(-1);}
	_bzero(usage, sizeof(struct rusage));

	{clock_t cl = clock()/cl_p->tick;
	switch (who) {
	 case RUSAGE_SELF:
		usage->ru_utime.tv_sec = cl - cl/10;
		usage->ru_utime.tv_sec = cl/10;
		usage->ru_maxrss = 512; 	/* fake something bogus */
		usage->ru_ixrss = 100;
		usage->ru_idrss = 100;
		usage->ru_minflt = 10;
		usage->ru_majflt = 100;
		usage->ru_nswap = 10;
		usage->ru_inblock = 100;
		usage->ru_oublock = 100;
		usage->ru_msgsnd = 100;
		usage->ru_msgrcv = 100;
		usage->ru_nsignals = 100;
		usage->ru_nvcsw = 100;
		usage->ru_nivcsw = 100;
		return(0);
	 case RUSAGE_CHILDREN:
		usage->ru_utime.tv_sec = cl - cl/10;
		usage->ru_utime.tv_sec = cl/10;
		usage->ru_maxrss = 512; 	/* fake something bogus */
		usage->ru_ixrss = 100;
		usage->ru_idrss = 100;
		usage->ru_minflt = 10;
		usage->ru_majflt = 100;
		usage->ru_nswap = 10;
		usage->ru_inblock = 100;
		usage->ru_oublock = 100;
		usage->ru_msgsnd = 100;
		usage->ru_msgrcv = 100;
		usage->ru_nsignals = 100;
		usage->ru_nvcsw = 100;
		usage->ru_nivcsw = 100;
		return(0);
	}}
	errno = EINVAL; 
	return(-1);
}

