/* stringx.h (emx+gcc) -- some non-Posix extensions; to be included in <string.h> */
/* $Id: stringx.h,v 1.5 2000/04/17 08:25:12 veit Exp $ */

#ifndef _STRINGX_H
#define _STRINGX_H

#if !defined (__STRICT_ANSI__) && !defined (_POSIX_SOURCE)

#include <string.h>

/* Machine-dependent inline versions */
#if (!__GNUC__ || __GNUC__ < 2 || (__GNUC__ == 2 && __GNUC_MINOR__ <= 7))
# define _STR_INL extern
#else
#define _STR_INL extern __inline__
#endif

#if defined(__cplusplus)
# ifndef __inline__ 
#  define __inline__ inline
# endif
extern "C" {
#endif

 /* bsd style functions   (mostly deprecated by ANSI C90)
     all new systems declare them in <string.h>, though (?!) */
extern int  bcmp(__const__ void*,__const__ void*,size_t);
extern void bcopy(__const__ void*,void*,size_t);
extern void bzero(void*,size_t);
extern int ffs(int);		/* no ANSI equivalent yet, not deprecated */
extern char*index(__const__ char*,int);
extern char*rindex(__const__ char*,int);
extern int  _bcmp(__const__ void*,__const__ void*,size_t);
extern void _bcopy(__const__ void*,void*,size_t);
extern void _bzero(void*,size_t);
extern int _ffs(int);		/* no ANSI equivalent yet, not deprecated */
extern char*_index(__const__ char*,int);
extern char*_rindex(__const__ char*,int);

/* not a standard interface; due to change ! */
extern int _strHasTrailingSlash(__const__ char*,__const__ size_t,__const__ int);
/* Remove trailing slashes from non-const variable PATH. */
extern void _strRemoveTrailingSlashes(char*);

_STR_INL int strcasecmp(__const__ char*,__const__ char*);
_STR_INL int memcasecmp(__const__ void*,__const__ void*,size_t);
_STR_INL int strncasecmp(__const__ char*,__const__ char*,size_t);
_STR_INL char*strsep(register char**,register __const__ char*);

#if defined (__cplusplus)
}
#endif


#if !(!__GNUC__ || __GNUC__ < 2 || (__GNUC__ == 2 && __GNUC_MINOR__ <= 7))

	_STR_INL int 	  			/* Compare S and T, ignoring case.  */
strcasecmp(__const__ char*s,__const__ char*t){return _stricmp(s,t);}
	_STR_INL int 	/* Compare no more than N chars of S and T, ignoring case.  */
memcasecmp(__const__ void*s,__const__ void*t,size_t n){return _memicmp(s,t,n);}
	_STR_INL  int 
strncasecmp(__const__ char*s,__const__ char*t,size_t n){return _strnicmp(s,t,n);}
	_STR_INL  char*
strsep(register char**s,register __const__ char*d){return _strsep(s,d);}

#endif

#endif /* not __STRICT_ANSI__  etc. */

#ifdef _DEBUG
# include <sys/debugx.h>
#endif

#endif /* not _STRINGX_H */
