/* stdlibx.h (libext+gcc) - ADDITIONAL GENERAL UTILITIES for stdlib.h

 	$Id: stdlibx.h,v 1.7 2000/05/31 09:12:05 veit Exp $
 */

#ifndef _STDLIBX_H_
#define _STDLIBX_H_

#include <stdlib.h>

#if defined(__cplusplus)
# ifndef __inline__ 
#  define __inline__ inline
#  define __const__  const
# endif
extern "C" {
#endif

#if !defined (__STRICT_ANSI__) || defined(_WITH_UNDERSCORE)

/* Machine-dependent inline versions */
#if (!__GNUC__ || __GNUC__ < 2 || (__GNUC__ == 2 && __GNUC_MINOR__ <= 7))
# define _STD_INL extern
#else
#define _STD_INL extern __inline__
#endif

extern __const__ unsigned int _libExtensions_vcmp; /* lib version */
extern __const__ unsigned int _libExtensions_env;
extern __const__ unsigned int _libExtensions_rev;
extern __const__ char         _libExtensions_vprt[5];

#if !defined(_POSIX_SOURCE) || defined(_WITH_UNDERSCORE)

/* bsd 4.4
 */
char *__getenv_findEnv(__const__ char*,size_t*);
char*_getenv(__const__ char *);
int _setenv(__const__ char*,__const__ char*,int);
extern void _srandom(unsigned long);
extern void _srandomdev(void);
extern char*_initstate(unsigned long,char*,long);
extern char*_setstate(char*);
extern long _random(void);
extern int _heapsort(void*,size_t,size_t,int(*)(__const__ void*,__const__ void*));
extern int _radixsort(__const__ unsigned char**,int,__const__ unsigned char*,unsigned);
extern int _sradixsort(__const__ unsigned char**,int,__const__ unsigned char*,unsigned);

_STD_INL char*_getenv(__const__ char *n){return(__getenv_findEnv(n, NULL));}

extern int _daemon(int,int); /* stubs: OS/2 uses detached processes instead! */

/* System V style 48-bit random number generator functions: 
    Seed random number generator.
  */
extern void srand48(long);
extern unsigned short*seed48(unsigned short[3]);
extern void lcong48(unsigned short[7]);
   /*  Return non-negative, double-precision floating-point value in [0.0,1.0).
    */
extern double drand48(void);
extern double erand48(unsigned short[3]);
  /* Return non-negative, long integer in [0,2^31).
   */
extern long lrand48(void);
extern long nrand48(unsigned short[3]);
  /* Return signed, long integers in [-2^31,2^31).
   */
extern long mrand48(void);
extern long jrand48(unsigned short[3]);

extern void*valloc(size_t);

	/* BSD */
extern long a64l(__const__ char*);
extern char *l64a(long);
extern char	*getbsize(int*,long*);
extern char	*cgetcap(char*,__const__ char*,int);
extern int	 cgetclose(void);
extern int	 cgetent(char**,char**,__const__ char*);
extern int	 cgetfirst(char**,char**);
extern int	 cgetmatch(char*,__const__ char*);
extern int	 cgetnext(char**,char**);
extern int	 cgetnum(char*,__const__ char*,long*);
extern int	 cgetset(__const__ char*);
extern int	 cgetstr(char*,__const__ char*,char**);
extern int	 cgetustr(char*,__const__ char*,char**);
extern int  daemon(int,int); /* OS/2 uses detached processes instead!*/
extern void unsetenv(const char *name);
extern int  setenv(__const__ char*,__const__ char*,int);
extern int  mergesort(void*,size_t,size_t,int(*)(__const__ void*,__const__ void*));
extern char*realpath(__const__ char*,char*);
extern int  getsubopt(char **, char * __const__ *, char **);
extern char*suboptarg;		/* getsubopt(3) external variable */

_STD_INL void srandom(unsigned long);
_STD_INL void srandomdev(void);
_STD_INL char* initstate(unsigned long seed,char*arg_state,long n);
_STD_INL char* setstate(char*);
_STD_INL long random(void);
_STD_INL int heapsort(void*,size_t,size_t,
  int(*c)(__const__ void*,__const__ void*));
_STD_INL int radixsort(__const__ unsigned char**,int,__const__ unsigned char*,unsigned);
_STD_INL int sradixsort(__const__ unsigned char**,int,__const__ unsigned char*,unsigned);

#include <sys/types.h> 		/* for quad_t, etc. */

typedef struct {
	quad_t quot;		/* quotient */
	quad_t rem;		/* remainder */
} qdiv_t;

extern qdiv_t qdiv(quad_t,quad_t);
extern quad_t qabs(quad_t);
extern quad_t strtoq(__const__ char*,char**,int);
extern u_quad_t strtouq(__const__ char*,char**,int base);

#if !(!__GNUC__ || __GNUC__ < 2 || (__GNUC__ == 2 && __GNUC_MINOR__ <= 7))

_STD_INL char*getenv(__const__ char *n){return(__getenv_findEnv(n, NULL));}
_STD_INL int putenv(__const__ char *str){return _putenv(str);}
_STD_INL int setenv(__const__ char*n,__const__ char*v,int r)
	{return _setenv(n,v,r);}
_STD_INL void srandom(unsigned long s) {return _srandom(s);}
_STD_INL void srandomdev(void) {return _srandomdev();}
_STD_INL char* initstate(unsigned long s,char*a,long n) 
	{return _initstate(s,a,n);}
_STD_INL char* setstate(char*c) {return setstate(c);}
_STD_INL long random(void) {return _random();}
_STD_INL int heapsort(void*b,size_t n,size_t s,
  int(*c)(__const__ void*,__const__ void*)){return _heapsort(b,n,s,c);}
_STD_INL int radixsort(__const__ unsigned char**a,int n,
	__const__ unsigned char*t, unsigned e) {return _radixsort(a,n,t,e);}
_STD_INL int sradixsort(__const__ unsigned char**a,int n,
	__const__ unsigned char*t, unsigned e) {return _sradixsort(a,n,t,e);}

#endif /* GNUC, etc. */
#endif /* !ANSI*/
#endif /* !UNDERSCORE,etc. */

#ifdef	__cplusplus
}
#endif

#ifdef _DEBUG
# include <sys/debugx.h>
#endif

#endif /* _STDLIBX_H_ */
