/*
 * Written by J.T. Conklin <jtc@netbsd.org>.
 * Public domain.
 */
#include <errno.h>
#include <stdlib.h>

	extern char *
l64a(long value)
{
	if (value < 0) {
		errno = EINVAL; return(NULL);
	} {
	 static char buf[8];
	 char *s = buf;
	 int i = 0;

		while (value != 0 && i < 6) {

		 int digit = value & 0x3f;

			if (digit < 2) 
				*s = digit + '.';
			else if (digit < 12)
				*s = digit + '0' - 2;
			else if (digit < 38)
				*s = digit + 'A' - 12;
			else
				*s = digit + 'a' - 38;

			value >>= 6;
			++s;
			++i;
		}
		*s = '\0';
		return(buf);
	}
}

