/* sys/types.h (libExt+gcc) - $Id: types.h,v 1.8 2000/05/31 09:12:05 veit Exp $ */

#ifndef _SYS_TYPES_H
#define _SYS_TYPES_H

#include <sys/cdefs.h>

#define	BSD	199306		/* System version (year & month). */
#define BSD4_3	1
#define BSD4_4	1		/* We fake a generic 4.4 BSD. */

#define __OpenBSD__	1	/* We use their headers and libraries. */
#define _POSIXOS2_VERSION	200004	/* System version (year & month). */

/* Machine type dependent parameters. */
#define	_MACHTYPES_H_ 		/* already in sys/types.h */
/*
 * Basic integral types.  Omit thetypedef if
 * not possible for a machine/compiler combination.
 */
#ifndef	__BIT_TYPES_DEFINED__
#define	__BIT_TYPES_DEFINED__ 1

typedef	__signed__ char		   int8_t;
typedef	unsigned char		 u_int8_t;
typedef	unsigned char		  uint8_t;
typedef	short			  int16_t;
typedef	unsigned short		u_int16_t;
typedef	unsigned short		 uint16_t;
typedef	int			  int32_t;
typedef	unsigned int		u_int32_t;
typedef	unsigned int		 uint32_t;
typedef	long long		  int64_t; /* LONGLONG */
typedef	unsigned long long	u_int64_t; /* LONGLONG */
typedef	unsigned long long	 uint64_t; /* LONGLONG */
typedef int32_t		 	register_t;

#if !defined(_POSIX_SOURCE)

#if !defined(_KEY_T)
#define _KEY_T
typedef long key_t;		/* IPC key (for Sys V IPC) */
#endif

typedef int	pd_entry_t;		/* page directory entry */
typedef int	pt_entry_t;		/* Mach page table entry */
typedef struct _physadr{int r[1];} *	physadr;
typedef struct _label_t{int val[6];} 	label_t;
#endif

typedef	unsigned long	vm_offset_t;
typedef	unsigned long	vm_size_t;

typedef unsigned long	vaddr_t;
typedef unsigned long	paddr_t;
typedef unsigned long	vsize_t;
typedef unsigned long	psize_t;

typedef	u_int64_t	u_quad_t;	/* quads */
typedef	int64_t		quad_t;
typedef	quad_t *	qaddr_t;

typedef	char *		caddr_t;	/* core address */
typedef	int32_t		daddr_t;	/* disk address */
typedef	u_int32_t	fixpt_t;	/* fixed point number */
typedef quad_t		rlim_t;		/* resource limit */
typedef	int32_t		segsz_t;	/* segment size */
typedef	int32_t		swblk_t;	/* swap offset */
typedef	u_int32_t	useconds_t;	/* microseconds */
typedef	int32_t		suseconds_t;	/* microseconds (signed) */

/*
 * XPG4.2 states that inclusion of <netinet/in.h> must pull these
 * in and that inclusion of <sys/socket.h> must pull in sa_family_t.
 * We put them here because there are other headers that require
 * these types and <sys/socket.h> and <netinet/in.h> will indirectly
 * include <sys/types.h>.  Thus we are compliant without too many hoops.
 */
typedef u_int32_t	in_addr_t;	/* base type for internet address */
typedef u_int16_t	in_port_t;	/* IP port type */
typedef u_int16_t	sa_family_t;	/* sockaddr address family type */
typedef int32_t		socklen_t;	/* length type for network syscalls */

#endif /* !__BIT_TYPES_DEFINED__ */

	/* In BSD <sys/types.h> is expected to define BYTE_ORDER.  */
#include <machine/endian.h>

#if !defined (_CLOCK_T)
#define _CLOCK_T
typedef long clock_t;
#endif

#if !defined (_PTRDIFF_T)
#define _PTRDIFF_T
typedef long ptrdiff_t;
#endif

#if !defined (_TIME_T)
#define _TIME_T
typedef unsigned long time_t;
#endif

#if !defined (_VA_LIST)
#define _VA_LIST
typedef char *va_list;
#endif

#if !defined (_WCHAR_T)
#define _WCHAR_T
typedef unsigned short wchar_t;
#endif

#if !defined (_SIZE_T)
#define _SIZE_T
typedef unsigned long size_t;
#endif

#if !defined (_SSIZE_T)
#define _SSIZE_T
typedef int ssize_t;
#endif

#if !defined (_TIME_T)
#define _TIME_T
typedef unsigned long time_t;
#endif

#if !defined (_INO_T)
#define _INO_T
typedef int ino_t;
#endif

#if !defined (_DEV_T)
#define _DEV_T
typedef int dev_t;
#endif

#if !defined (_OFF_T)
#define _OFF_T
typedef long off_t;
#endif

#if !defined (_MODE_T)
#define _MODE_T
typedef int mode_t;
#endif

#if !defined (_NLINK_T)
#define _NLINK_T
typedef int nlink_t;
#endif

#if !defined (_UID_T)
#define _UID_T
typedef int uid_t;
#endif

#if !defined (_PID_T)
#define _PID_T
typedef int pid_t;
#endif

#if !defined (_GID_T)
#define _GID_T
typedef int gid_t;
#endif

#if !defined (_POSIX_SOURCE) && !defined(_XOPEN_SOURCE)
typedef unsigned char  u_char;
typedef unsigned short u_short;
typedef unsigned int	u_int;
typedef unsigned long  u_long;
typedef unsigned char  unchar;		/* Sys V compatibility */
typedef unsigned short ushort;		/* Sys V compatibility */
typedef unsigned int	uint;		/* Sys V compatibility */
typedef unsigned long  ulong;		/* Sys V compatibility */

typedef int64_t	int64;

 /* In BSD sys/types.h defines `fd_set' and the FD_* macros for `select'
  */
#define	NBBY	8		/* number of bits per byte; CHAR_BIT */
/*
 * Select uses bit masks of file descriptors in longs.  These macros
 * manipulate such bit fields (the filesystem macros use chars).
 * FD_SETSIZE may be defined by the user, but the default here should
 * be enough for most uses.
 */
#if !defined (FD_SETSIZE)
#define	FD_SETSIZE      256
#elif FD_SETSIZE < 256
#error FD_SETSIZE must be at least 256
#endif

#if !defined (_FD_SET_T)
#define _FD_SET_T
typedef unsigned long fd_mask;
#define NFDBITS	(sizeof(fd_mask) * NBBY)	/* bits per mask */

#ifndef howmany
#define	howmany(x, y)	(((x) + ((y) - 1)) / (y))
#endif

typedef	struct _fd_set {
	fd_mask	fds_bits[howmany(FD_SETSIZE, NFDBITS)];
} fd_set;
#endif

#ifndef FD_SET
#define	FD_SET(n, p)	((p)->fds_bits[(n)/NFDBITS] |= (1 << ((n) % NFDBITS)))
#define	FD_CLR(n, p)	((p)->fds_bits[(n)/NFDBITS] &= ~(1 << ((n) % NFDBITS)))
#define	FD_ISSET(n, p)	((p)->fds_bits[(n)/NFDBITS] & (1 << ((n) % NFDBITS)))
#ifdef _KERNEL
#define	FD_COPY(f, t)	bcopy(f, t, sizeof(*(f)))
#define	FD_ZERO(p)	bzero(p, sizeof(*(p)))
#else
#define	FD_COPY(f, t)	memcpy(t, f, sizeof(*(f)))
#define	FD_ZERO(p)	memset(p, 0, sizeof(*(p)))
#endif
#endif /* FD_SET */

/* Forward structure declarations for function prototypes.  We include the
 * common structures that cross subsystem boundaries here; others are mostly
 * used in the same place that the structure is defined.
 */
struct	proc;
struct	pgrp;
struct	ucred;
struct	rusage;
struct	file;
struct	buf;
struct	tty;
struct	uio;

#endif /* !(_POSIX_SOURCE) */
#endif /* not _SYS_TYPES_H */
